% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_2r.R
\name{p_2r}
\alias{p_2r}
\alias{gen_2r}
\title{p-value from comparing two or more correlations simulation}
\usage{
p_2r(
  n,
  r.ab1,
  r.ab2,
  r.ac1,
  r.ac2,
  r.bc1,
  r.bc2,
  r.ad1,
  r.ad2,
  r.bd1,
  r.bd2,
  r.cd1,
  r.cd2,
  n2_n1 = 1,
  two.tailed = TRUE,
  type = c("independent", "overlap", "nonoverlap"),
  test = "fisher1925",
  gen_fun = gen_2r,
  return_analysis = FALSE,
  ...
)

gen_2r(n, R, ...)
}
\arguments{
\item{n}{sample size}

\item{r.ab1}{correlation between variable A and B in sample 1}

\item{r.ab2}{correlation between variable A and B in sample 2}

\item{r.ac1}{same pattern as \code{r.ab1}}

\item{r.ac2}{same pattern as \code{r.ab2}}

\item{r.bc1}{...}

\item{r.bc2}{...}

\item{r.ad1}{...}

\item{r.ad2}{...}

\item{r.bd1}{...}

\item{r.bd2}{...}

\item{r.cd1}{...}

\item{r.cd2}{...}

\item{n2_n1}{sample size ratio}

\item{two.tailed}{logical; use two-tailed test?}

\item{type}{type of correlation design}

\item{test}{hypothesis method to use. Defaults to 'fisher1925'}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{matrix} with \code{n} rows.
Default uses \code{\link{gen_2r}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}

\item{R}{a correlation matrix constructed from the inputs
to \code{\link{p_2r}}}
}
\value{
a single p-value
}
\description{
Function utilizes \code{\link[cocor]{cocor}} to perform correlation
comparison for independent, overlapping, and non-overlapping designs.
}
\examples{

# independent (same x-y pairing across groups)
p_2r(100, r.ab1=.5, r.ab2=.6)

# return cocor object for further analysis
p_2r(100, r.ab1=.5, r.ab2=.6, return_analysis = TRUE)

\donttest{

   # estimate empirical power
   p_2r(n=100, r.ab1=.5, r.ab2=.6) |> Spower()

   # estimate n required to reach 80\% power
   p_2r(n=NA, r.ab1=.5, r.ab2=.6) |>
        Spower(power=.80, interval=c(100, 5000))

}

# overlap (same y, different xs)
p_2r(100, r.ab1=.5, r.ab2=.7,
          r.ac1=.3, r.ac2=.3,
          r.bc1=.2, r.bc2=.2, type = 'overlap')

# nonoverlap (different ys, different xs)
p_2r(100, r.ab1=.5, r.ab2=.6,
          r.ac1=.3, r.ac2=.3,
          r.bc1=.2, r.bc2=.2,
          r.ad1=.2, r.ad2=.2,
          r.bd1=.4, r.bd2=.4,
          r.cd1=.2, r.cd2=.2,
          type = 'nonoverlap')


}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
