% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_mauchly.test.R
\name{p_mauchly.test}
\alias{p_mauchly.test}
\alias{gen_mauchly.test}
\alias{mauchlys.test}
\title{p-value from Mauchly's Test of Sphericity simulation}
\usage{
p_mauchly.test(
  n,
  sigma,
  gen_fun = gen_mauchly.test,
  return_analysis = FALSE,
  ...
)

gen_mauchly.test(n, sigma, ...)

mauchlys.test(X)
}
\arguments{
\item{n}{sample size}

\item{sigma}{symmetric covariance/correlation matrix passed to \code{gen_fun}}

\item{gen_fun}{function used to generate the required data.
Object returned must be a \code{matrix} with \code{K} columns and
\code{n} rows. Default uses \code{\link{gen_mauchly.test}}
to generate multivariate normal samples.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}

\item{X}{a matrix with \code{k} columns and \code{n} rows}
}
\value{
a single p-value
}
\description{
Perform simulation experiment for Mauchly's Test of Sphericity using
the function \code{mauchlys.test}, returning a p-value.
Assumes the data are from a multivariate
normal distribution, however this can be modified.
}
\examples{

sigma <- diag(c(1,2,1))
sigma

# H0 test that sphericity holds
p_mauchly.test(100, sigma=sigma)

# return analysis object
p_mauchly.test(100, sigma=sigma, return_analysis=TRUE)

# Null is true
sigma.H0 <- diag(3)
p_mauchly.test(100, sigma=sigma.H0)


\donttest{
    # empirical power estimate
    p_mauchly.test(100, sigma=sigma) |> Spower()

    # empirical Type I error estimate
    p_mauchly.test(100, sigma=sigma.H0) |> Spower()
}

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
