% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfitStMoMo.R
\name{plot.fitStMoMo}
\alias{plot.fitStMoMo}
\title{Plot fitted parameters from a stochastic mortality model}
\usage{
\method{plot}{fitStMoMo}(x, nCol = 2, parametricbx = TRUE, type = "l", ...)
}
\arguments{
\item{x}{an object of class \code{"fitStMoMo"} with the fitted 
parameters of a stochastic mortality model.}

\item{nCol}{number of columns to use in the plot.}

\item{parametricbx}{if \code{FALSE} parametric age-modulating terms, 
which don't need to be estimated, are not plotted.}

\item{type}{what type of plot should be drawn. See 
\code{\link[graphics]{plot}}.}

\item{...}{additional arguments to control graphical appearance.
See \code{\link[graphics]{plot}}.}
}
\description{
Plot fitted parameters of a stochastic mortality model of class 
\code{"fitStMoMo"}.
}
\examples{

#Fit and plot a Lee-Carter model
LCfit <- fit(lc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext, 
             ages = EWMaleData$ages, years = EWMaleData$years,
             ages.fit = 55:89)
plot(LCfit)
plot(LCfit, type = "p", pch = 19)

#Fit and plot a CBD model
CBDfit <- fit(cbd(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext, 
              ages = EWMaleData$ages, years = EWMaleData$years,
              ages.fit = 55:89)
plot(CBDfit)
plot(CBDfit, parametricbx = FALSE)
plot(CBDfit, nCol = 1, parametricbx = FALSE, lwd = 2)

}

