% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dqdate.R
\name{dqdate}
\alias{dqdate}
\title{Data quality check of date variables}
\usage{
dqdate(data)
}
\arguments{
\item{data}{a data.frame or data.table}
}
\value{
a data.frame which contains the variable, non-missing values, missing values,
         minimum and maximum of all date variables
}
\description{
Takes in a data, and returns summary of date variables
}
\details{
\code{dqdate} produces summary of all date variables in the data. The function
 identifies all variables as date if they are of class 'Date' or 'IDate'.

 Generally the dates are imported in R as character. They must be converted to
 an appropriate date format and then the function should be used.

 The summary includes variable, non-missing values, missing values, minimum and
 maximum of the date variabes. Input data can be a 'data.frame' or 'data.table' but the
 output summary will be a 'data.frame' only.
}
\examples{
# A 'data.frame'
df <- data.frame(date = c('2012-11-21', '2015-1-4', '1996-4-30', '1979-9-23', '2005-5-13'),
                 temperature = c(26, 32, 35, 7, 14))

# Convert character date to date format
df[, 'date'] <- as.Date(df[, 'date'])

# Generate a data quality report of date variables
summaryDate <- dqdate(data = df)
}
\author{
Akash Jain
}
\seealso{
\code{\link{dqcontinuous}}, \code{\link{dqcategorical}}, \code{\link{contents}}
}

