% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rmdupkey.R
\name{rmdupkey}
\alias{rmdupkey}
\title{Remove observations with duplicate keys from data}
\usage{
rmdupkey(data, by)
}
\arguments{
\item{data}{a data.frame or data.table}

\item{by}{a character vector of keys to be used}
}
\value{
a two element list: unique data and duplicate data
}
\description{
Takes in a data and key, and returns data with duplicate observations by key removed
}
\details{
Remove duplicate observations by key(s) is what this function does. How it is
 different from other functions that remove duplicates is that \code{rmdupkey}
 works for both 'data.frame' and 'data.table', and it also returns the duplicated
 observations.

 Many a times we want to go back to the duplicated observations and see why that
 duplication occured. One can pick the duplicated observations using the
 code given in example.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c(1, 2, 1, 1), y = c(3, 3, 1, 3))

# Remove duplicate observations by key from data
ltDf <- rmdupkey(data = df, by = c('x'))
unqDf <- ltDf$unqData
dupDf <- ltDf$dupData
}
\author{
Akash Jain
}
\seealso{
\code{\link{randomise}}, \code{\link{factorise}}, \code{\link{rmdupobs}}
}

