% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.StepReg.R
\name{plot.StepReg}
\alias{plot.StepReg}
\title{Visualize Stepwise Regression Results}
\usage{
\method{plot}{StepReg}(
  x,
  strategy = attr(x, "nonhidden"),
  process = c("overview", "detail"),
  num_digits = 6,
  ...
)
}
\arguments{
\item{x}{A StepReg object containing the results of stepwise regression analysis.}

\item{strategy}{Character. Specifies which selection strategy to visualize:
\itemize{
  \item "forward" - Forward selection
  \item "backward" - Backward elimination
  \item "bidirection" - Bidirectional selection
  \item "subset" - Best subset selection
}
Default is the first strategy name in the StepReg object.}

\item{process}{Character. Specifies the type of visualization to display:
\itemize{
  \item "detail" - Shows detailed step-by-step selection process with variable entry/removal
  \item "overview" - Shows summary of the selection process with metric values
}
Default is "overview".}

\item{num_digits}{Integer. Number of decimal places to display in the plots.
Default is 6.}

\item{...}{Additional argument passed to plotting functions (currently not used).}
}
\value{
A ggplot object showing either:
  \itemize{
    \item For "detail" process: A heatmap showing variable selection status at each step
    \item For "overview" process: A line plot showing metric values across steps
  }
}
\description{
Creates informative visualizations of the variable selection process from a StepReg object.
This function generates two types of plots: detailed step-by-step selection process and
an overview of the final selected variables.
}
\details{
The function creates different types of visualizations based on the selection strategy:
  \itemize{
    \item For forward/backward/bidirectional selection:
      \itemize{
        \item detail view shows a heatmap with green tiles for added variables,
              tan tiles for removed variables, and gray tiles for non-selected variables
        \item Overview shows metric values across steps with variable labels
      }
    \item For subset selection:
      \itemize{
        \item detail view shows a heatmap of selected variables at each step
        \item Overview shows metric values for different subset sizes
      }
  }
}
\examples{
\dontrun{
# Load example data
data(mtcars)

# Run stepwise regression with multiple strategies
formula <- mpg ~ .
result <- stepwise(
  formula = formula,
  data = mtcars,
  type = "linear",
  strategy = c("forward", "bidirection", "subset"),
  metric = c("AIC", "BIC", "SL")
)

# Generate default overview plot
plot(result)

# Generate detailed plot for forward selection
plot(result, strategy = "forward", process = "detail")

# Generate overview plot with 3 decimal places
plot(result, strategy = "bidirection", process = "overview", num_digits = 3)
}

}
\seealso{
\code{\link{stepwise}} for creating StepReg objects
}
