% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_DesMat.R
\name{construct_DesMat}
\alias{construct_DesMat}
\title{Construct the Design Matrix

Constructs the design matrix with one column for every (fixed)
parameter to be estimated and one row for every cluster for every timepoint.
This function calls `construct_trtMat` to construct a matrix with
`#cluster` columns and `#timepoints` rows, indicating treatment status
fore each cluster at each timepoint. This is then transformed into the first
column of the design matrix. `construct_CovMat` further calls
`construct_timeajust` to get the fixed effect(s) of the timepoints.

Note: Unlike the usual notation, the treatment effect is in the first column
(for easier access by higher level functions).}
\usage{
construct_DesMat(
  Cl = NULL,
  trtDelay = NULL,
  dsntype = "SWD",
  timepoints = NULL,
  timeAdjust = "factor",
  period = NULL,
  trtmatrix = NULL,
  timeBlk = NULL,
  N = NULL,
  INDIV_LVL = FALSE
)
}
\arguments{
\item{Cl}{integer (vector), number of clusters per sequence group (in SWD),
or number in control and intervention (in parallel designs)}

\item{trtDelay}{numeric (possibly vector), value(s)
between 0 and 1 specifying
the intervention effect in the first (second ... ) intervention phase}

\item{dsntype}{character, defines the type of design. Options are "SWD",
"parallel" and "parallel_baseline", defaults to "SWD".}

\item{timepoints}{numeric (scalar or vector), number of timepoints (periods).
If design is swd, timepoints defaults to length(Cl)+1.
Defaults to 1 for parallel designs.}

\item{timeAdjust}{character, specifies adjustment for time periods.
One of the following: "factor", "linear", "none", "periodic".
Defaults to "factor".}

\item{period}{numeric (scalar)}

\item{trtmatrix}{an optional user defined matrix
to define treatment allocation}

\item{timeBlk}{an optional user defined matrix that defines
the time adjustment in one cluster.
Is repeated for every cluster.}

\item{N}{numeric, number of individuals per cluster. Either a scalar, vector
of length #Clusters or a matrix of dimension #Clusters x timepoints.
Defaults to 'rep(1,sum(Cl))' if not passed.}

\item{INDIV_LVL}{logical, should the computation be conducted on an
individual level? This leads to longer run time and is
mainly for diagnostic purposes.}
}
\value{
an object of class DesMat
}
\description{
Construct the Design Matrix

Constructs the design matrix with one column for every (fixed)
parameter to be estimated and one row for every cluster for every timepoint.
This function calls `construct_trtMat` to construct a matrix with
`#cluster` columns and `#timepoints` rows, indicating treatment status
fore each cluster at each timepoint. This is then transformed into the first
column of the design matrix. `construct_CovMat` further calls
`construct_timeajust` to get the fixed effect(s) of the timepoints.

Note: Unlike the usual notation, the treatment effect is in the first column
(for easier access by higher level functions).
}
\examples{
construct_DesMat(Cl=c(2,0,1))
construct_DesMat(Cl=c(2,0,1), N=c(1,3,2))

}
