% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closed_formulae.R
\name{VarClosed_Li}
\alias{VarClosed_Li}
\title{Closed formula for treatment variance, with proportional decay}
\usage{
VarClosed_Li(trtMat, tau, psi, N, AR)
}
\arguments{
\item{trtMat}{a matrix trtMat to define treatment allocation,
where rows and columns correspond to cluster and timepoints, respectively}

\item{tau}{numeric, standard deviation of random intercepts}

\item{psi}{numeric, random subject specific intercept.}

\item{N}{numeric, number of individuals per cluster.}

\item{AR}{numeric (scalar), It defines the AR(1)-correlation of random effects.}
}
\value{
numeric, variance of the estimator for treatment effect
}
\description{
From Li et al "Design and analysis considerations for cohort stepped wedge
cluster randomized trials with a decay correlation structure"
}
\examples{
##  test setting, from Hussey&Hughes 2007  ####
trtMat <- construct_DesMat(c(6,6,6,6))$trtMat
tau <- .025 ; N <- 100 ; psi <- .1 ; AR <- .6
tmp <- VarClosed_Li(trtMat, tau=tau, psi=psi, N=N, AR=AR)
tTestPwr((.05-.032), se=sqrt(tmp), Inf)
wlsPower(Cl=rep(6,4), mu0=.05, mu1=.032, AR=AR,
         tau=tau, N=N, sigma=0, psi=psi, verbose=0)
}
