% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_fnxs.R
\name{sim.fit.mult.add.data.batch}
\alias{sim.fit.mult.add.data.batch}
\title{Simulate fitness data under multiplicative and additive models}
\usage{
sim.fit.mult.add.data.batch(epi.model, mut.vals, coe.vals, sig.vals, w.wt = 1,
  n.reps.ea = 100, print.status = FALSE, outdir, wts)
}
\arguments{
\item{epi.model}{\code{mult/add} Epistasis model to simulate under.}

\item{mut.vals}{Vector of number of mutations to simulate}

\item{coe.vals}{Vector of stickbreaking coefficients to simulate}

\item{sig.vals}{Vector of sigma values to simulate}

\item{w.wt}{Fitness of the wildtype. Default 1.}

\item{n.reps.ea}{Number of replicates per parametric condition}

\item{print.status}{TRUE/FALSE. Should loop counters be printed.}

\item{outdir}{The path to write output files to (see details about file names).}

\item{wts}{Weight to give mutation on wildtype background vs other backgrounds. Default is c(2,1).}
}
\value{
Nothing. Instead results are written to output files and deposited in inst/extdata.
The files are named by appending the method
}
\description{
Simulate fitness data under multiplicative and additive models
}
\details{
Function contains a loop for combining each value of mut.vals, coe.vals and sig.vals,
generating data under the specified model and then fitting it. \cr

Results are written to files; the name of the output files are formed by concatenating the outpath argument to
the epi.model argument. Separate files are generated for each
number of mutations (because the dimensionality of the output file changes with the number of mutations).
The output files are tab-delimited text files with one row per replicate.
The first 5 columns provide the parameter values and the rest of the columns give parameter estimates and
measures of fit.
}
\examples{
\dontrun{
sim.fit.mult.add.data.batch("mult",
  c(3,4,5),
  c(0.1, 0.3, 0.5),
  c(0.02, 0.05, 0.08),
  1,
  100,
  print.status=TRUE,
  outdir="~/Desktop",
  c(2,1))
  }
}

