% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_combine.R
\name{param_combine}
\alias{param_combine}
\title{Overall Population Estimate: Aggregating Subgroup-Specific Parameter Estimates}
\usage{
param_combine(param.dat, combine = "SS", alpha_ovrl = 0.05, ...)
}
\arguments{
\item{param.dat}{Parameter data-set with subgroup-specific point estimates, SEs, and
sample sizes.}

\item{combine}{Method to combine subgroup-specific estimates. Default is "adaptive".
combine="SS" uses sample size weighting.}

\item{alpha_ovrl}{Two-sided alpha level for overall population. Default=0.05}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with overall population point estimate, SE, and CI
}
\description{
Function that combines subgroup-specific estimates to obtain an overall population
estimate. Options including sample size weighting and adaptive weighting (default; as
described in Marceau-West and Mehrotra (to appear)).
}
