% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_c50.R
\name{stratified_rf}
\alias{stratified_rf}
\title{Stratified Random Forest}
\usage{
stratified_rf(df, targetvar, groups, mtry, ntrees = 500,
  class_quotas = NULL, fulldepth = TRUE, replacement = TRUE)
}
\arguments{
\item{df}{Data to build the model (data.frame only).}

\item{targetvar}{String indicating the name of the target or outcome variable in the data.}

\item{groups}{Unnamed list containing, at each entry, a group of variables (as a string vector with their names).}

\item{mtry}{A numeric vector indicating how many variables to take from each group when building each tree.}

\item{ntrees}{Number of trees to grow.}

\item{class_quotas}{How many rows from each class to use in each tree (useful when there is a class imbalance). Must be a numeric vector or a named list with the number of desired rows to sample for each level of the target variable. Note that using more rows than the data originally had might result in incorrect out-of-bag error estimates.}

\item{fulldepth}{Whether to grow the trees to full depth.}

\item{replacement}{Whether to sample rows with replacement.}
}
\description{
Random Forest that works with groups of predictor variables. When building a tree, a number of variables is taken from each group separately. Useful when rows contain information about different things (e.g. user information and product information) and it's not sensible to make a prediction with information from only one group of variables, or when there are far more variables from one group than the other and it's desired to have groups appear evenly on trees.
}
\details{
Trees are grown using the C5.0 algorithm. Implementation of everything outside the tree-building is in native R code, thus might be slow. Currently works for classification only.
}
\examples{
data(iris)
groups <- list(c("Sepal.Length","Sepal.Width"),c("Petal.Length","Petal.Width"))
mtry <- c(1,1)
m <- stratified_rf(iris,"Species",groups,mtry,ntrees=2)
summary(m)
}
\keyword{stratified_rf}
