% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmod.R
\name{fmod}
\alias{fmod}
\title{Universal remainder function}
\usage{
fmod(x, xmax, xmin = 0, bounds = "[[")
}
\arguments{
\item{x}{vector of floating point numbers}

\item{xmax, xmin}{the limits of the interval}

\item{bounds}{how to deal with boundaries (right- or left-open; '[['
or ']]')}
}
\description{
Given a [xmin,xmax[ or ]xmin,xmax] interval, this function
determines the remainder of each numeric relative to this interval. In other
words if the interval was repeated over the whole numeric domain, this
function determines where each value would be positioned in a given
repetition.
}
\examples{
fmod(c(1260.23,360),360)

fmod(c(1260.23,360),360,bounds = "]]")

fmod(c(1260.23,360),360 + 180, 180)

}
\seealso{
\code{\link{incfix}}, \code{\link{dipfix}} and \code{\link{transphere}}
}
