% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framesvg.R
\name{framesvg}
\alias{framesvg}
\title{Draws a standardised pointsvg object into a given frame}
\usage{
framesvg(
  object,
  xmin,
  xmax,
  ymin,
  ymax,
  forget = NULL,
  front = NULL,
  back = NULL,
  standard = FALSE,
  keep.ratio = FALSE,
  col = NA,
  border = "black",
  density = NA,
  angle = 45,
  lwd = par("lwd"),
  lty = par("lty"),
  scol = border,
  slty = lty,
  slwd = lwd,
  plot = TRUE,
  output = FALSE
)
}
\arguments{
\item{object}{a pointsvg object (svg object imported as data frame
using \code{\link{pointsvg}}).}

\item{xmin, xmax}{the x value for the left and right side of the symbol}

\item{ymin, ymax}{the y value for the low and high side of the symbol}

\item{forget}{the elements that should be discarded, by their id
or index (i.e. name or number of appearance).}

\item{front, back}{the elements to be put in front and back position,
by their id or index (i.e. name or number of appearance). By default the
order is the one of the original .svg file.}

\item{standard}{whether to standardise (centre to (0,0), rescale so
that extreme points are at -1 and 1) or not (T or F)}

\item{keep.ratio}{if the object is to be  standardised, whether to
keep the x/y ratio (T or F)}

\item{col}{the polygones background color. If density is specified with
a positive value this gives the color of the shading lines.}

\item{border}{the lines color.}

\item{density}{the density of shading lines, in lines per inch. The
default value of NULL means that no shading lines are drawn.}

\item{angle}{the slope of shading lines, given as an angle in degrees
(counter-clockwise)}

\item{lty, lwd}{the border line type and width, see ?par for details.}

\item{scol, slty, slwd}{the colour, type and width of the shading lines.}

\item{plot}{whether to add to a plot}

\item{output}{whether to output the new object coordinates}
}
\description{
Draws a svg object imported as data frame using
\code{\link{pointsvg}} into a given frame.
}
\details{
The \code{\link{centresvg}} and
\code{\link{framesvg}} have a lot of similarities with the
\code{\link{multigons}} function: the graphical parameters are mostly
identical. However there is a strong distinction between the -svg functions
and multigons: when providing several graphical arguments, multigons will
attribute them to each polygon, whereas the .svg functions will use them for
each repetition of the .svg object. Using the latter, the graphical
parameters will be applied to all the elements of a drawing. If you want
a finer personalisation you have to use multigons and multilines (or an
hybrid of the two, yet to be coded).
}
\examples{
# Simple use

object <- example.ammonite

xmin <- c(8,7)
xmax <- c(10,9)
ymin <- c(7,6)
ymax <- c(9,8)

plot(c(-10,10), c(-10,10), type = "n")

abline(v = unique(c(xmax, xmin)))
abline(h = unique(c(ymax, ymin)))

framesvg(object, xmin, xmax, ymin, ymax, col = c("white", "grey80"))

# Precision positioning

l <- c(1,2,3)
r <- c(0,1,2)
h  <- c(4,3,4)
i   <- c("B1","B2","B3")

basic.litholog <- litholog(l,r,h,i)

whiteSet(xlim = c(0,4), ylim = c(0,3), ytick = 1, ny = 10)

framesvg(example.lense, 0,3,1,2, forget = "P1", border = "red", lwd = 3)

multigons(basic.litholog$i, basic.litholog$xy, basic.litholog$dt)

}
\seealso{
Similar functions: \code{\link{centresvg}} and
\code{\link{placesvg}}

Change the drawing: \code{\link{changesvg}} and \code{\link{clipsvg}}

Uses \code{\link{ignore}} to avoid drawing unnecessary objects
}
