% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_switch_function.R
\name{Diversity}
\alias{Diversity}
\alias{homogeneity}
\alias{dissimilarity}
\alias{contrast}
\alias{entropy}
\alias{entropyNorm}
\title{Spatial Structural Diversity Metrics}
\usage{
homogeneity(
  rank,
  delta,
  Hetx,
  vMat_big = NULL,
  SpatMat,
  nrp,
  narm,
  display_progress = TRUE,
  ...
)

dissimilarity(
  rank,
  delta,
  Hetx,
  vMat_big = NULL,
  SpatMat,
  nrp,
  narm,
  display_progress,
  ...
)

contrast(
  rank,
  delta,
  Hetx,
  vMat_big = NULL,
  SpatMat,
  nrp,
  narm,
  display_progress,
  ...
)

entropy(
  rank,
  delta,
  Hetx,
  vMat_big = NULL,
  SpatMat,
  nrp,
  narm,
  display_progress,
  ...
)

entropyNorm(
  rank,
  delta,
  Hetx,
  vMat_big = NULL,
  SpatMat,
  nrp,
  narm,
  display_progress,
  ...
)
}
\arguments{
\item{rank}{logical. Should values be replaced with ranks in each co-occurrence 
matrix (GLCM)? Defaults to \code{FALSE}.}

\item{delta}{numeric, takes 3 options: \code{0}, \code{1}, or \code{2}. 
The \code{delta} parameter defines how the differences between pixel values within a pixel 
pair are weighted.  
If \code{rank = TRUE}, delta defines how the differences between ranks are weighted.  
The default value is \code{0} (no weight). Set \code{delta = 1} for absolute weights, 
or \code{delta = 2} for squared weights. 
The \code{delta} parameter can only be set when the metric \code{entropy} is used. 
The metric \code{dissimilarity} automatically employs \code{delta = 1}, and \code{contrast} employs \code{delta = 2}.}

\item{Hetx}{the structural diversity matrix that is returned by an internal function
to the \code{\link{strucDiv}} and \code{\link{strucDivNest}} functions. 
The structural diversity metric is calculated on every element
of the GLCM, which generates the structural diversity matrix \code{Hetx}. The sum of this
matrix is assigned to the center pixel of the moving window.}

\item{vMat_big}{matrix. The matrix containing the pixel values of the outer scale. 
Defaults to \code{NULL}, in which case no prior information is used.}

\item{SpatMat}{the GLCM that is returned by an internal function
to the \code{\link{strucDiv}} and \code{\link{strucDivNest}} functions.}

\item{nrp}{integer. The total number of pixel pairs. \code{nrp} is calculated internally by the 
functions \code{\link{strucDiv}} and \code{\link{strucDivNest}} and passed to the structural 
diversity metric functions.}

\item{narm}{logical. Should NAs be removed? 
\code{narm} is automatically set to 0 if \code{na.handling = na.pass}, 
and to 1 if \code{na.handling = na.omit}.}

\item{display_progress}{logical. Should a progress bar be displayed?}

\item{...}{possible further arguments.}
}
\description{
The functions \code{entropy} , \code{entropyNorm}, \code{contrast}, \code{dissimilarity} and \code{homogeneity}
are the (spatial) structural diversity metrics used in the default configurations of \code{\link{strucDiv}} and \code{\link{strucDivNest}}. 
Structural diversity entropy is \code{entropy} with different \code{delta} parameters. Shannon entropy is employed, when \code{delta = 0}. 
Shannon entropy has a window-dependent maximum when \code{\link{strucDiv}} is used, which may be violated when \code{\link{strucDivNest}} is used, 
depending on the posterior probabilities of pixel value co-occurrences.
Additionally, the value gradient is considered when \code{delta = 1} or \code{delta = 2}. 
The values of structural diversity entropy with \code{delta = 1} or \code{delta = 2} are not restricted and depend on the values of the input raster.
the metric \code{entropyNorm} is Shannon entropy normalized over maximum entropy, which depends on the size of the moving window when no nesting is used. 
The metric \code{entropyNorm} ranges between 0 and 1, when \code{\link{strucDiv}} is used, but may be larger than 1 when \code{\link{strucDivNest}} is used, 
depending on the posterior probabilities of pixel value co-occurrences.
The metrics \code{contrast} and \code{dissimilarity} consider the value gradient, their values are not restricted and depend on the values of the input raster.
The metric \code{homogeneity} quantifies the closeness of empirical probabilities to the diagonal and ranges between 0 and 1 when \code{\link{strucDiv}} is used, 
but may be larger than 1 when \code{\link{strucDivNest}} is used, depending on the posterior probabilities of pixel value co-occurrences.
}
\details{
These functions are used internally and are called 
as an argument to the \code{\link{strucDiv}} and \code{\link{strucDivNest}} functions.
}
