% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential_batting.R
\name{seqlr.score.pred}
\alias{seqlr.score.pred}
\title{Compute score of cutoff for predictive case}
\usage{
seqlr.score.pred(data, yvar, censorvar, xvar, trtvar, cutoff, type, class.wt,
  dir, nsubj, min.sigp.prcnt)
}
\arguments{
\item{data}{input data frame.}

\item{yvar}{response variable name.}

\item{censorvar}{censoring variable name.}

\item{xvar}{name of predictor for which cutpoint needs to be obtained.}

\item{trtvar}{treatment variable name.}

\item{cutoff}{a specific cutpoint for which the score needs to be computed.}

\item{type}{"c" continuous; "s" survival; "b" binary.}

\item{class.wt}{vector of length 2 used to weight the accuracy score , useful when there is class imbalance in binary data defaults to c(1,1).}

\item{dir}{direction of cut.}

\item{nsubj}{number of subjects.}

\item{min.sigp.prcnt}{desired proportion of signature positive group size for a given cutoff.}
}
\value{
score (p-value of treatment*subgroup interaction) for the given cutoff.
}
\description{
Compute score of cutoff for predictive case
}
