% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-read_data.R
\name{read_df_raw_from_csv}
\alias{read_df_raw_from_csv}
\title{Read in Raw Data}
\usage{
read_df_raw_from_csv(file_loc, tracer_accuracy, t_period)
}
\arguments{
\item{file_loc}{String; The location of the file, including the file name.}

\item{tracer_accuracy}{The accuracy of the IV tracer used. See the device's manual
to find the exact value at which Isc readings are no longer accurate.}

\item{t_period}{Data period for the Psuedo-IV curves. Addded as a column to the dataframe
based on the timestamp. Use units of days, i.e. daily periods should have t_period 1,
weekly periods should have t_period 7, etc.}
}
\value{
df_raw, a dataframe containing the raw IV curve data
}
\description{
Given the file location of a .csv of Hbase-Formatted IV curve data,
this function reads in the data, filters missing temperature data,
and checks for a nonzero maximum power point, in case of power loss.
It resets the timestamps based on the minimum timestamp, and filters
Isc values for the tracer's accuracy.
Finally, a n_period counter is added to the dataframe.
}
\examples{
df_subset <- head(df_wbw, 3)

tf <- tempfile()
write.csv(df_subset, tf)

# uses 0 as tracer accuracy to avoid filtering
df_test <- read_df_raw_from_csv(tf, 0, 7)

}
