% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_VlnPlot.R
\name{supercell_VlnPlot}
\alias{supercell_VlnPlot}
\title{Violin plots}
\usage{
supercell_VlnPlot(
  ge,
  supercell_size = NULL,
  clusters,
  features = NULL,
  idents = NULL,
  color.use = NULL,
  pt.size = 0,
  pch = "o",
  y.max = NULL,
  y.min = NULL,
  same.y.lims = FALSE,
  adjust = 1,
  ncol = NULL,
  combine = TRUE,
  angle.text.y = 90,
  angle.text.x = 45
)
}
\arguments{
\item{ge}{a gene expression matrix (ncol same as number of super-cells)}

\item{supercell_size}{a vector with supercell size (ordered the same way as in \code{ge})}

\item{clusters}{a vector with clustering information (ordered the same way as in \code{ge})}

\item{features}{name of genes of for which gene expression is plotted}

\item{idents}{idents (clusters) to plot (default all)}

\item{color.use}{colors for idents}

\item{pt.size}{point size (0 by default)}

\item{pch}{shape of jitter dots}

\item{y.max}{max of y axis}

\item{y.min}{min of y axis}

\item{same.y.lims}{same y axis for all plots}

\item{adjust}{param of geom_violin}

\item{ncol}{number of columns in combined plot}

\item{combine}{combine plots into a single \link[patchwork]{patchwork}ed ggplot object. If FALSE, return a list of ggplot}

\item{angle.text.y}{rotation of y text}

\item{angle.text.x}{rotation of x text}
}
\value{
combined ggplot or list of ggplots if \code{combine = TRUE}
}
\description{
Violin plots (similar to \link[Seurat]{VlnPlot} with some changes for super-cells)
}
