% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Choleski.R
\name{Choleski}
\alias{Choleski}
\alias{cholZX}
\alias{cholXZ}
\title{Choleski multiplication with Toeplitz variance matrices.}
\usage{
cholZX(Z, acf)

cholXZ(X, acf)
}
\arguments{
\item{Z}{Length-\code{N} or \code{N x p} matrix of residuals.}

\item{acf}{Length-\code{N} autocorrelation vector of the Toeplitz variance matrix.}

\item{X}{Length-\code{N} or \code{N x p} matrix of observations.}
}
\value{
Size \code{N x p} residual or observation matrix.
}
\description{
Multiplies the Choleski decomposition of the Toeplitz matrix with another matrix, or solves a system of equations with the Cholesky factor.
}
\details{
If \code{C == t(chol(toeplitz(acf)))}, then \code{cholZX} computes \code{C \%*\% Z} and \code{cholZX} computes \code{solve(C, X)}.  Both functions use the Durbin-Levinson algorithm.
}
\examples{
N <- 10
p <- 2
W <- matrix(rnorm(N * p), N, p)
acf <- exp(-(1:N - 1))
cholZX(Z = W, acf = acf)
cholXZ(X = W, acf = acf)
}
