% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_ftest.R
\name{power.ftest}
\alias{power.ftest}
\title{Power Calculations for an F-test}
\usage{
power.ftest(
  num_df = NULL,
  den_df = NULL,
  cohen_f = NULL,
  alpha_level = Superpower_options("alpha_level"),
  beta_level = NULL,
  liberal_lambda = Superpower_options("liberal_lambda")
)
}
\arguments{
\item{num_df}{degrees of freedom for numerator}

\item{den_df}{degrees of freedom for denominator}

\item{cohen_f}{Cohen's f effect size. Note: this is the sqrt(f2) if you are used to using pwr.f2.test}

\item{alpha_level}{Alpha level used to determine statistical significance.}

\item{beta_level}{Type II error probability (power/100-1)}

\item{liberal_lambda}{Logical indicator of whether to use the liberal (cohen_f^2\*(num_df+den_df)) or conservative (cohen_f^2\*den_df) calculation of the noncentrality (lambda) parameter estimate. Default is FALSE.}
}
\value{
num_df = degrees of freedom for numerator, 
den_df = degrees of freedom for denominator, 
cohen_f = Cohen's f effect size, 
alpha_level = Type 1 error probability, 
beta_level = Type 2 error probability,
power = Power of test (1-beta_level\*100%), 
lambda = Noncentrality parameter estimate (default = cohen_f^2\*den_df, liberal = cohen_f^2\*(num_df+den_df))
}
\description{
Compute power of test or determine parameters to obtain target power. Inspired by the pwr.f2.test function in the pwr package, but allows for varying noncentrality parameter estimates for a more liberal (default in pwr.f2.test) or conservative (default in this function) estimates (see Aberson, Chapter 5, pg 72).
}
\section{References}{

Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd ed.). Hillsdale,NJ: Lawrence Erlbaum.
Aberson, C. (2019). Applied Power Analysis for the Behavioral Sciences (2nd ed.). New York,NY: Routledge.
}

\examples{
design_result <- ANOVA_design(design = "2b",
n = 65,
mu = c(0,.5),
sd = 1,
plot = FALSE)
x1 = ANOVA_exact2(design_result, verbose = FALSE)
ex = power.ftest(num_df = x1$anova_table$num_df, 
den_df = x1$anova_table$den_df, 
cohen_f = x1$main_result$cohen_f,
alpha_level = 0.05,
liberal_lambda = FALSE)
}
