% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_SurvSurv.R
\name{model_fit_measures}
\alias{model_fit_measures}
\title{Goodness of fit information for survival-survival model}
\usage{
model_fit_measures(fitted_model)
}
\arguments{
\item{fitted_model}{returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}.}
}
\value{
a named vector containing the goodness-of-fit measures
}
\description{
This function returns several goodness-of-fit measures for a model fitted by
\code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. These are primarily intended for model selection.
}
\details{
The following goodness-of-fit measures are returned in a named vector:
\itemize{
\item \code{tau_0} and \code{tau_1}: (latent) value for Kendall's tau in the estimated
model.
\item \code{log_lik}: the maximized log-likelihood value.
\item \code{AIC}: the Aikaike information criterion of the fitted model.
}
}
\examples{
library(Surrogate)
data("Ovarian")
#For simplicity, data is not recoded to semi-competing risks format, but is
#left in the composite event format.
data = data.frame(
  Ovarian$Pfs,
  Ovarian$Surv,
  Ovarian$Treat,
  Ovarian$PfsInd,
  Ovarian$SurvInd
)
ovarian_fitted =
    fit_model_SurvSurv(data = data,
                       copula_family = "clayton",
                       nknots = 1)
model_fit_measures(ovarian_fitted)
}
