% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partition-Data.R
\name{PartitionData}
\alias{PartitionData}
\title{Partition Data by Outcome Missingness Pattern.}
\usage{
PartitionData(t, s, X, Z = NULL)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Target model matrix.}

\item{Z}{Surrogate model matrix.}
}
\value{
List containing these components:
\itemize{
  \item `Orig` original data.
  \item `Dims` dimensions and names.
  \item `Complete`, data for complete cases.
  \item `TMiss`, data for subjects with target missingness.
  \item `SMiss`, data for subjects with surrogate missingness.
  \item `IPs`, inner products. 
}
}
\description{
Partition Data by Outcome Missingness Pattern.
}
\examples{
# Generate data.
n <- 1e3
X <- rnorm(n)
Z <- rnorm(n)
data <- rBNR(X = X, Z = Z, b = 1, a = -1)
data_part <- PartitionData(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  Z = Z
)
}
