% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosting_function.R
\name{print.boosting}
\alias{print.boosting}
\title{Prints the call and coefficients from boosting model selection}
\usage{
\method{print}{boosting}(x, ...)
}
\arguments{
\item{x}{output from boosting_core function.}

\item{...}{ignored}
}
\value{
list containing the coefficient vector and function call.
}
\description{
This function displays the coefficient estimates of all variables from a
model generated with the boosting_core function.
}
\examples{
data <- simulate_survival_cox(true_beta=c(1,1,1,1,1,0,0,0,0,0))
formula <- as.formula("Surv(time,delta) ~ strata(strata_idx) + V1 + V2 + 
V3 + V4 + V5 + V6 + V7 + V8 + V9 + V10" )
boosting.output <- boosting_core(formula, data, rate=0.1, num_iter=500)
print(boosting.output)

}
\keyword{boosting}
\keyword{gradient}
