% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Find_h.R
\name{Find.h}
\alias{Find.h}
\title{To find parameter of a uniform dropout censoring distribution under
a generalized gamma survival distribution or a log-logistic survival distribution.}
\usage{
Find.h(lfu, R, T, q, mu, sigma, eta, theta)
}
\arguments{
\item{lfu}{the dropout censoring probability.}

\item{R}{the recuritment duration.}

\item{T}{the study duration.}

\item{q, mu, sigma}{shape, location and scale parameters of an assumed generalized gamma distribution for the control arm.
A character string q="LLG" indiactes an assumed log-logistic survival distribution
\eqn{F_0(y;\xi,\zeta)=1/(1+(y/\xi)^{-\zeta})} for the control arm, where \eqn{\xi} = mu and \eqn{\zeta} = sigma.}

\item{eta, theta}{parameters of the entry distribution with \eqn{\eta \ge -\theta/R} and \eqn{\eta >0}
(\eqn{\theta=0} for the uniform dropout censoring).}
}
\value{
the parameter h of the uniform dropout censoring distribution U(0,h).
}
\description{
A function finds parameter h of a uniform dropout censoring distribution U(0,h)
with a generalized gamma survival distribution or a log-logistic survival distribution
for a given dropout censoring probability.
}
\examples{
Find.h(lfu=0.15, R=2, T=3, q=1, mu=0.367, sigma=1, eta=1, theta=0)
Find.h(lfu=0.15, R=2, T=3, q="LLG", mu=1, sigma=1.75, eta=1, theta=0)
}
