% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSize_FixAlter.R
\name{SSize.FixAlter}
\alias{SSize.FixAlter}
\title{Maximum sample size for a group sequential test
under a generalized gamma survival distribution or a log-logistic survival distribution.}
\usage{
SSize.FixAlter(t, R, T, FUN.C, para0, para1 = NULL, haz.r, rho = 0,
  eta = 1, theta = 0, px = 0.5, spf = 1, alpha = 0.05, power = 0.8)
}
\arguments{
\item{t}{the interim analysis time (vector).}

\item{R}{the recuritment duration.}

\item{T}{the study duration.}

\item{FUN.C}{the cumulative distribution function of dropout censoring. \cr
FUN.C = function(y) punif(y,0,h) for a uniform dropout censoring U(0,h); \cr
FUN.C = function(y) rep(0,length(y)) for assuming no dropout censoring.}

\item{para0}{c(q0,mu0,sigma0), parameters of an assumed generalized gamma distribution for the control arm.
A character string q0="LLG" indiactes an assumed log-logistic survival distribution
\eqn{F_0(y;\xi,\zeta)=1/(1+(y/\xi)^{-\zeta})} for the control arm, where \eqn{\xi} = mu0 and \eqn{\zeta} = sigma0.}

\item{para1}{c(q1,mu1,sigma1), parameters of an assumed generalized gamma distribution for the treatment arm.
A character string q1="LLG" indiactes an assumed log-logistic survival distribution
\eqn{F_1(y;\xi,\zeta)=1/(1+(y/\xi)^{-\zeta})} for the treatment arm, where \eqn{\xi} = mu1 and \eqn{\zeta} = sigma1.}

\item{haz.r}{the hazard ratio of the treatment arm to the control arm (numeric or function).}

\item{rho}{the power in the weight of the Harrington-Fleming statistic.
\eqn{\rho=0} for the logrank test; \eqn{\rho=1} for the Wilcoxon test.}

\item{eta, theta}{parameters of the entry distribution with \eqn{\eta \ge -\theta/R} and \eqn{\eta >0}
(\eqn{\theta=0} for the Uniform dropout censoring).}

\item{px}{the proportion of patients assigned to the treatment arm.
The default is px = 0.5 indicating 1:1 allocation.}

\item{spf}{1 = O’Brien-Fleming-type; 2 = Pocock-type alpha-spending function. The default is spf = 1.}

\item{alpha}{the type I error. The default is alpha = 0.05.}

\item{power}{A desired value of the power. The default is power = 0.8.}
}
\value{
\item{MaxSize}{the maximum sample size.}

\item{ExpSize}{the expected sample size.}

\item{ExpEvent}{the expected number of events.}

\item{A.power}{actual achieved power.}

\item{Info.fractions}{information fractions at times of all the interim analyses.}

\item{boundary}{the monitoring boundary values of
the standardized Harrington-Fleming statistic at all the interim analyses.}
}
\description{
A function obtains maximum sample sizes and associated expected values
for a group sequential design under a generalized gamma survival distribution or a log-logistic survival distribution
for a given dropout censoring distribution.
}
\examples{
# Assume an exponential (log-logistic) survival distribution
# with q0=sigma0=1, mu0=0.367 (xi0=1, zeta0=1.75) for the control arm,
# a uniform patient entry (eta=1,theta=0) and a uniform dropout censoring distribution Unif(0,h)
# having a 15\% censoring probability (lfu=0.15) for a study with R=2, T=3 and the interim
# analysis time at t=1,1.5,2,2.5.

# To obtain the required h for the uniform dropout censoring distribution.
Find.h(lfu=0.15, R=2, T=3, q=1, mu=0.367, sigma=1, eta=1, theta=0) ## exponential
Find.h(lfu=0.15, R=2, T=3, q="LLG", mu=1, sigma=1.75, eta=1, theta=0) ## log-logistic

# To obtain the maximum sample size for testing a treatment difference of a hazard ratio of 2/3
# with a type-I error of 0.05 and a power of 0.8.
SSize.FixAlter(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.018),
para0=c(1,0.367,1), para1=NULL, haz.r=2/3, rho=0, eta=1, theta=0) # exponential
SSize.FixAlter(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.211),
para0=c("LLG",1,1.75), para1=NULL, haz.r=2/3, rho=0, eta=1, theta=0) # log-logistic

# To obtain the maximum sample size for testing H_0:F_0=F_1 with a type-I error of 0.05
# and a power of 0.8, where F_1 is an exponential (log-logistic) distribution
# with the parameter para1=c(1,0.772,1) (para1=c("LLG",1.5,1.75)).
SSize.FixAlter(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.018),
para0=c(1,0.367,1), para1=c(1,0.772,1), haz.r=NULL, rho=0, eta=1, theta=0) # exponential
SSize.FixAlter(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.211),
para0=c("LLG",1,1.75), para1=c("LLG",1.5,1.75), haz.r=NULL, rho=0, eta=1, theta=0) # log-logistic

}
\references{
Hsu, C.-H., Chen, C.-H, Hsu, K.-N. and Lu, Y.-H. (2018). A useful design utilizing the information fraction
                in a group sequential clinical trial with censored survival data. To appear in Biometrics.

Azzalini, A. and Genz, A. (2015). The R package `mnormt':
The multivariate normal and 't' distributions (version 1.5-3). URL \emph{http://azzalini.stat.unipd.it/SW/Pkg-mnormt}.

Casper, C. and Perez, O. A. (2014). The R package `ldbounds':
Lan-DeMets method for group sequential boundaries (version 1.1-1). URL \emph{https://cran.r-project.org/web/packages/ldbounds/index.html}.

Jackson, C., Metcalfe, P. and Amdahl, J. (2017). The R package `flexsurv':
Flexible Parametric Survival and Multi-State Models (version 1.1). URL \emph{https://github.com/chjackson/flexsurv-dev}.
}
