% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survexpMC.R
\name{survexpMC}
\alias{survexpMC}
\title{Exponential survival analysis with MCMC}
\usage{
survexpMC(m1, n1, m2, n2, chains, iter, data)
}
\arguments{
\item{m1}{Starting column number from where variables of high dimensional data will be selected.}

\item{n1}{Ending column number till where variables of high dimensional data will get selected.}

\item{m2}{Starting column number from where demographic observations starts}

\item{n2}{Ending column number of the demographic observations}

\item{chains}{Number of MCMC chains}

\item{iter}{Number of MCMC iterations}

\item{data}{High dimensional data having survival duration as (OS), event information as Death (1 if died, or 0 if alive).}
}
\value{
survexpMCout A data set listing estimated posterior means and deviances
}
\description{
Survival analysis with exponential distribution by MCMC
}
\examples{
\dontrun{
##
data(headnneck)
survexpMC(m1=8,n1=12,m2=4,n2=7,chains=2,iter=10,data=headnneck)
##
}
}
\references{
Kumar, M., Sonker, P. K., Saroj, A., Jain, A., Bhattacharjee, A.,
 & Saroj, R. K. (2020). Parametric survival analysis using R: Illustration
 with lung cancer data. \emph{Cancer Reports}, \bold{3(4)}, e1210.
}
\seealso{
survweibMC
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
