% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SyncRNG.R
\docType{class}
\name{SyncRNG-class}
\alias{SyncRNG-class}
\alias{SyncRNG}
\title{A Reference Class for SyncRNG}
\description{
See \link{syncrng-package} for package documentation.
}
\section{Fields}{

\describe{
\item{\code{seed}}{The seed for the random number generator}

\item{\code{state}}{The current state of the RNG, should not be modified by the 
user}
}}

\section{Methods}{

\describe{
\item{\code{initialize(..., seed = 0)}}{Initialize the RNG using the C function R_syncrng_seed}

\item{\code{rand()}}{Generate a single random float in the range [0, 1)}

\item{\code{randbelow(n)}}{Generate a random integer below a given number}

\item{\code{randi()}}{Generate a single random 32-bit integer}

\item{\code{shuffle(x)}}{Randomly shuffle a provided array of values}
}}

\examples{
s <- SyncRNG(seed=123456)
for (i in 1:10)
  cat(s$randi(), '\n')

}
