% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_07_claim_payment_time.R
\name{claim_payment_delay}
\alias{claim_payment_delay}
\title{Inter-Partial Delays}
\usage{
claim_payment_delay(
  frequency_vector,
  claim_size_list,
  no_payments_list,
  settlement_list,
  settlement_mean_function,
  simulate_delay_function
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{claim_size_list}{list of claim sizes.}

\item{no_payments_list}{list of number of partial payments.}

\item{settlement_list}{list of settlement delays.}

\item{settlement_mean_function}{target mean of the settlement delay
as a function of \code{claim_size} and \code{occurrence_period} (see the
documentation of \code{claim_closure} for more details).}

\item{simulate_delay_function}{a function that generates the payment delay
pattern of a particular claim (as a vector of size = \code{no_pmt}), taking
as input \code{no_pmt}, \code{claim_size}, \code{setldel},
\code{occurrence_period}, and \code{setldel_mean_function} (see Details
for the default simulation algorithm).}
}
\description{
Simulates and returns the inter-partial delays (i.e. the delay of one
partial payment relative to the previous) of each payment for each of the
claims occurring in each of the periods.
}
\details{
Returns a compound list structure such that the \eqn{j}th component
of the \eqn{i}th sub-list gives the payment delay pattern (as a vector) for
the \eqn{j}th claim of occurrence period \eqn{i}. \cr \cr
The default \code{simulate_delay_function} is split into 2 cases. \cr \cr
\strong{Case 1: claims with at least 4 partial payments.} The simulation takes
2 steps. \cr
First we sample the last payment delay from a Weibull distribution with
mean = 1 quarter (automatically converted to the relevant \code{time_unit}, a
global variable that the user is required to define at the top of their code)
and CoV = 20\%. Then we sample the remaining payment delays
from a second Weibull distribution with CoV at 35\% and
\deqn{mean = settlement_mean_function(claim_size, occurrence_period)/no_pmt}
where \code{settlement_mean_function()} is the function that
we used in \code{claim_closure} to generate the settlement delays.
\cr \cr
\strong{Case 2: claims with less than 4 partial payments.} Proceed as in Case 1
but without separating out the simulation of the last payment delay (i.e.
ignore step 1).
}
\examples{
# set up
n_vector <- claim_frequency(I = 10)
claim_sizes <- claim_size(n_vector)
no_payments <- claim_payment_no(n_vector, claim_sizes)
setldel <- claim_closure(n_vector, claim_sizes)

# with default setting
pmtdel <- claim_payment_delay(n_vector, claim_sizes, no_payments, setldel)
pmtdel[[1]][[1]] # payment delays for claim 1 of occurrence period 1
}
