\name{tam.se}

\alias{tam.se}
\alias{tam.mml.se}

\title{
Standard Error Estimation
}
\description{
Standard error computation for objects of the classes \code{tam} and \code{tam.mml}. 
Still to come for objects of class \code{tam.jml}.
}
\usage{
tam.se(tamobj, ...)
tam.mml.se(tamobj, numdiff.parm = 0.001)
}

\arguments{
\item{tamobj}{
    An object generated by \code{tam.mml}
}
\item{numdiff.parm}{Step width parameter for numerical
  differentiation
    }
\item{\dots}{Further arguments to be passed
    }    
}

\details{
Covariances between parameters estimates are ignored in this standard
error calculation. The standard error is obtained by numerical
differentiation.
}

\value{
A list with following entries:
\item{xsi}{
    Data frame with \eqn{\xi} parameters (\code{est}) 
    an their corresponding standard errors (\code{se})
        }
\item{beta}{
    Data frame with \eqn{\beta} regression parameters and 
    their standard error estimates
        }
}

%\references{
%% ~put references to the literature/web site here ~
%}

%\author{
%%  ~~who you are~~
%}

\note{
Standard error estimation for estimated slope parameters
in the matrix \eqn{B} is not yet implemented. The same
applies to standard errors for variances and covariances.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}

\examples{
data(sim.rasch)
# estimate Rasch model
mod1 <- tam.mml(resp=sim.rasch) 
# standard error estimation
se1 <- tam.se( mod1 ) 

##   > print(se1$xsi, digits=3 )
##      xsi.index xsi.label     est     se
##   1          1        I1 -1.9590 0.0654
##   2          2        I2 -1.8570 0.0639
##   3          3        I3 -1.7444 0.0623
##   4          4        I4 -1.6407 0.0610
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Standard errors}
%% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
