\name{tam.wle}

\alias{tam.wle}
\alias{tam.mml.wle}
\alias{tam.jml.WLE}

\title{
Weighted Likelihood Estimation and Maximum Likelihood Estimation of
Person Parameters
}

\description{
Compute weighted likelihood estimator for objects of classes \code{tam},
\code{tam.mml} and \code{tam.jml},  respectively.
}

\usage{
tam.wle(tamobj, ...)

tam.mml.wle(tamobj, WLE=TRUE, adj=0.3, Msteps=20, convM=1e-04)

tam.jml.WLE(tamobj, resp, resp.ind, A, B, nstud, nitems, maxK, convM, 
    PersonScores, theta, xsi, Msteps, WLE=FALSE)
}

\arguments{
  \item{tamobj}{
     An object generated by \code{tam.mml} or \code{tam.jml}
}
  \item{WLE}{
     A logical which indicates if the weighted likelihood estimate
     (WLE, \code{WLE=TRUE}) or the maximum likelihood estimate (MLE, \code{WLE=FALSE})
     should be used.
}
  \item{adj}{
     Adjustment in WLE estimation for extreme scores (i.e. all or none
     items were correctly solved)
}
  \item{Msteps}{
     Maximum number of iterations
}
  \item{convM}{
     Convergence criterion
  }
\item{resp}{Data frame with item responses (only for \code{tam.jml.WLE})
}
\item{resp.ind}{Data frame with response indicators (only for \code{tam.jml.WLE})
}
\item{A}{Design matrix \eqn{A} (only for \code{tam.jml.WLE})
}
\item{B}{Design matrix \eqn{B} (only for \code{tam.jml.WLE})
}  
\item{nstud}{\dots (only for \code{tam.jml.WLE})
}
\item{nitems}{\dots (only for \code{tam.jml.WLE})
}
\item{maxK}{\dots (only for \code{tam.jml.WLE})
}
\item{PersonScores}{\dots (only for \code{tam.jml.WLE})
}
\item{theta}{\dots (only for \code{tam.jml.WLE})
}
\item{xsi}{\dots (only for \code{tam.jml.WLE})
}
\item{\dots}{Further arguments to be passed}
}

%\details{
%%  ~~ If necessary, more details than the description above ~~
%}

\value{
For \code{tam.wle.mml} it is a data frame with following columns:
\item{pid}{Person identifier}
\item{PersonScores}{Score of each person}
\item{PersonMax}{Maximum score of each person}
\item{theta}{Weighted likelihood estimate (WLE) or MLE}
\item{error}{Standard error of the WLE or MLE}
\item{WLE.rel}{WLE reliability (same value for all persons)}

For \code{tam.jml.WLE} it is a list with following entries:
\item{theta}{Weighted likelihood estimate (WLE) or MLE}
\item{errorWLE}{Standard error of the WLE or MLE}
\item{meanChangeWLE}{Mean change between updated and previous ability
    estimates from last iteration}
}

\references{
Warm, T. A. (1989). Weighted likelihood estimation of ability in item response theory.
\emph{Psychometrika}, \bold{54}, 427-450.
}

%\author{
%%  ~~who you are~~
%}

%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}

\examples{
data(sim.rasch)
# estimate Rasch model
mod1 <- tam.mml(resp=sim.rasch) 
# WLE estimation
wle1 <- tam.wle( mod1 )
## ----
## WLE Reliability = 0.894 
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{WLE}
\keyword{MLE}
\keyword{Person parameter estimation}
%% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
