% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{TCpoints2lines}
\alias{TCpoints2lines}
\title{Convert Points to Line Segments}
\usage{
TCpoints2lines(pts_v)
}
\arguments{
\item{pts_v}{A `SpatVector` of points (from the `terra` package).}
}
\value{
A `SpatVector` containing line geometries created from the input points.
}
\description{
This function converts a set of point geometries into line segments.
The input vector must be a set of points, and the function will draw line segments between consecutive points.
An additional point is extrapolated from the last two points to ensure the final segment is complete.
}
\examples{
library(terra)
# Create example points
pts <- vect(matrix(c(1, 1, 2, 2, 3, 3), ncol=2), type="points")
# Convert points to line segments
TClines <- TCpoints2lines(pts)

}
