% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_simulate_func.R
\name{fmri_simulate_func}
\alias{fmri_simulate_func}
\title{real-valued fMRI data simulation}
\usage{
fmri_simulate_func(
  dim_data,
  mask = NULL,
  ons = c(1, 21, 41, 61, 81, 101, 121, 141),
  dur = c(10, 10, 10, 10, 10, 10, 10, 10)
)
}
\arguments{
\item{dim_data}{a vector of length 3 to identify the dimension of fMRI data user wants to simulate}

\item{mask}{a 3D array of 1’s and 0’s or NULL. To specify the area inside the brain shell.
One may use the mask data provided by this package, or generate a 3D array of 1’s and 0’s of the same dimension with the fMRI data to be generated.
If NULL, then the function would generate a 3D sphere mask.}

\item{ons}{a vector of the start time points of the time period when the fMRI data receives stimulation}

\item{dur}{a vector of the time period when the fMRI data receives stimulation}
}
\value{
an array with the specified dimension

a list of four elements
\itemize{
  \item fmri_data - the fMRI data generated by the function as specialized values.
  \item mask - mask of the fMRI data.
  \item ons - a vector of the start time points of the time period when the fMRI data receives stimulation.
  \item dur - a vector of the time period when the fMRI data receives stimulation. Notice that the length of ons 
  is equal to the length of dur, and all the time period when the data does not receive the simulations have the same 
  duration as its former 'on' time period.
  \item on_time - a vector that specifies when motion happens.
}
}
\description{
a real-valued fMRI data simulation function, used to simply generate a 3D fMRI data associated with brain area with activated parts inside.
}
\details{
The function \code{fmri_simulate_func} is used to simulate fMRI data with specified dimension and total time points. 
The fMRI data can be brain-shaped by using the mask data provided in our package, if the dimension fits the same as our data (c(64, 64. 40)).
Otherwise, the function will generate a 3D sphere data with multiple activated part inside. The activated parts can be detected based on the p values.
}
\examples{
# sample 3D data of mask provided by the package
dim(mask)

# the input dimension is the dimension we want for our simulated fMRI data
fmri_generate = fmri_simulate_func(dim_data = c(64, 64, 40), mask = mask, 
                                   ons = c(1, 21, 41, 61, 81, 101, 121, 141), 
                                   dur = c(10, 10, 10, 10, 10, 10, 10, 10))

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
