% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_plot_landscape.R
\name{plot.landscape}
\alias{plot.landscape}
\title{Plot Persistence Landscape}
\usage{
\method{plot}{landscape}(x, ...)
}
\arguments{
\item{x}{a \code{landscape} object.}

\item{...}{extra parameters including \describe{
\item{top.k}{the number of landscapes to be plotted (default: 5).}
\item{colored}{a logical; \code{TRUE} to assign different colors for landscapes, or \code{FALSE} to use grey color for all landscapes.}
}}
}
\value{
a \pkg{ggplot2} object.
}
\description{
Given a persistence landscape object in S3 class \code{landscape}, visualize the 
landscapes using \pkg{ggplot2}.
}
\examples{
\donttest{
# Use 'iris' data
XX = as.matrix(iris[,1:4])

# Compute Persistence diagram and landscape of order 0 
homology  = diagRips(XX)
landscape = diag2landscape(homology, dimension=0)

# Plot with 'barcode'
opar <- par(no.readonly=TRUE)
plot(landscape)
par(opar)
}

}
\concept{utility}
