% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{diagram_to_df}
\alias{diagram_to_df}
\title{Convert a TDA/TDAstats persistence diagram to a data frame.}
\usage{
diagram_to_df(d)
}
\arguments{
\item{d}{the output of a TDA/TDAstats homology calculation, like \code{\link[TDA]{ripsDiag}} or \code{\link[TDAstats]{calculate_homology}}.}
}
\value{
a 3-column data frame, with each row representing a topological feature. The first column is the feature dimension (a non-negative integer), the second column is the birth radius of the feature and the third column is the death radius.
}
\description{
The output of homology calculations from the R packages TDA
and TDAstats are not dataframes. This function converts these 
outputs into a data frame either for further usage in this package or
for personalized analyses.
}
\details{
If a diagram is constructed using a TDA function like \code{\link[TDA]{ripsDiag}}
with the `location` parameter set to true then the return value will ignore the location information.
}
\examples{

if(require("TDA") & require("TDAstats"))
{
  # create a persistence diagram from a 2D Gaussian
  df = data.frame(x = rnorm(n = 20,mean = 0,sd = 1),y = rnorm(n = 20,mean = 0,sd = 1))

  # compute persistence diagram with ripsDiag from package TDA
  phom_TDA = TDA::ripsDiag(X = df,maxdimension = 0,maxscale = 1)

  # convert to data frame
  phom_TDA_df = diagram_to_df(d = phom_TDA)

  # compute persistence diagram with calculate_homology from package TDAstats
  phom_TDAstats = TDAstats::calculate_homology(mat = df,dim = 0,threshold = 1)

  # convert to data frame
  phom_TDAstats_df = diagram_to_df(d = phom_TDAstats)
}
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
