% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.soft.omni.R
\name{p.soft.omni}
\alias{p.soft.omni}
\title{CDF of omnibus soft-thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
p.soft.omni(q, n, TAU1)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{TAU1}{- a vector of truncation parameters (=normalization parameters). Must be in non-descending order.}
}
\value{
The left-tail probability of the null distribution of omnibus soft-thresholding Fisher's p-value combination statistic.
}
\description{
CDF of omnibus soft-thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
q = 0.01
n = 20
TAU1 = c(0.01, 0.05, 0.5, 1)
p.soft.omni(q=q, n=n, TAU1=TAU1)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.soft.omni}} for the definition of the statistic.
}
