% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileMDB.R
\name{read_fileMDB}
\alias{read_fileMDB}
\title{Read a \link{fileMDB} from a path}
\usage{
read_fileMDB(
  path,
  dbInfo = NULL,
  dataModel = NULL,
  collectionMembers = NULL,
  check = TRUE,
  n_max = 10,
  verbose = TRUE
)
}
\arguments{
\item{path}{the path to a folder with data or with the following structure:
\itemize{
\item \strong{data}: a folder with the data
\item \strong{DESCRIPTION.json}: a file with db information
\item \strong{model}: a folder with the data model json file with the same name as the
one given in the DESCRIPTION.json file
}}

\item{dbInfo}{a list or a json file with DB information:
\strong{"name"} (only mandatory field), "title", "description",
"url" (or "reference URL"),
"version", "maintainer". If NULL (default), the DESCRIPTION.json file found
in path. This file should also contains relevant parameters for the
\code{\link[readr:read_delim]{readr::read_delim()}} function. For example:
\itemize{
\item \strong{delim delimiter} (default: '\\\\t')
\item \strong{quoted_na}: Should missing values inside quotes be treated
as missing values or as strings or strings.
WARNING: THIS PARAMETER IS NOT TAKEN INTO ACCOUNT WITH readr>=2.0.0.
\item \strong{na}: String used for missing values. The default value for reading
a fileMDB is "NA". But the default value for writing a fileMDB is
"<NA>".
This value is written in the DESCRIPTION.json file to avoid ambiguity
when reading the fileMDB.
}}

\item{dataModel}{a \link[ReDaMoR:RelDataModel]{ReDaMoR::RelDataModel} object or json file.
If NULL (default), the model json file found in path/model.}

\item{collectionMembers}{the members of collections as provided to the
\link{collection_members<-} function. If NULL (default), the members
are taken from json files found in path/model/Collections}

\item{check}{logical: if TRUE (default) the data are confronted to the
data model}

\item{n_max}{maximum number of records to read
for checks purpose (default: 10). See also \code{\link[ReDaMoR:confront_data]{ReDaMoR::confront_data()}}.}

\item{verbose}{if TRUE (default) display the data confrontation report}
}
\value{
A \link{fileMDB} object
}
\description{
Read a \link{fileMDB} from a path
}
\seealso{
\link{get_confrontation_report}, \link[ReDaMoR:format_confrontation_report]{ReDaMoR::format_confrontation_report}
and \link[ReDaMoR:format_confrontation_report_md]{ReDaMoR::format_confrontation_report_md} for getting and formatting
the report confronting the data to the model.
}
