% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_compare.R
\name{plot_compare}
\alias{plot_compare}
\title{Graphic Comparison Between Estimates and True Values}
\usage{
plot_compare(est, true, cex = 1, width = 1, P = 6/7, AI = TRUE)
}
\arguments{
\item{est}{a numeric vector; estimations.}

\item{true}{a numeric vector; true values.}

\item{cex}{numeric; size of point to be plotted. (default: 1)}

\item{width}{numeric; width of fitted straight line. (default: 1)}

\item{P}{numeric, between 0 and 1; position for superimposing values of appraisal indexes. (default: 6/7)}

\item{AI}{logical; \code{TRUE} for presenting appraisal indexes while \code{FALSE} for not. (default: TRUE)}
}
\description{
Provided that you have the true values of missing observations, you can compare them
  with the results of interpolation. \code{plot_compare} visualizes the comparison
  between estimates and true values. (NB: this plotting function can also be used
  in other similar situations involving comparison between estimates and true values.)
}
\details{
Attentions:
\itemize{
  \item The values in \code{est} and \code{true} vectors should be arranged in the same order,
  in correspondence with the sequence of observations.
  \item If the maximum value of either \code{est} or \code{true} is greater than 1000, or the
  minimum is smaller than -1000, please make appropriate transformation that limits your data
  to bound [-1000,1000].
}

In the plot:
\itemize{
  \item The big red point is the origin.
  \item The red line stands for straight line \code{y = x}.
  \item The blue line stands for fitted straight line.
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression(data = data, h = 1, v = 1, alpha = 0.01) # regression
basis$percentage # see the percentage of cointegrated relationships
est <- tscsEstimate(matrix = basis$coef_matrix, newdata = newdata, h = 1, v = 1) # estimation
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,3], true = true) # graphic comparison
index <- appraisal_index(est = est$estimate[,3], true = true); # RMSE & std
index

## data visualization:

plot_dif(data = data[,1:2], h = 1, v = 1) # differentiate boundary and interior spatial locations
plot_NA(newdata = newdata) # show spatial locations with missing value, for a cross-section data
plot_map(newdata = newdata) # plot the 2D spatial map, for a cross-section data
}
}
\seealso{
\code{appraisal_index}
}
