% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{quantile_response}
\alias{quantile_response}
\title{quantile_response}
\usage{
quantile_response(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control
parameters}
}
\value{
A quantile of the response variable.
}
\description{
Return the specified quantile of the response distribution.
}
\details{
This function returns the response quantiles associated with a
specified percentile. The default behavior is to return the median -- i.e.
50th-percentile.
}
\examples{
## Generate example data containing response and treatment
N <- 100
y = runif( min = 0, max = 20, n = N )
df <- as.data.frame( y )
names( df )  <- "y"
df$trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6),
                  replace = TRUE )

## Default behavior is to return the median
quantile_response( df )
median( df$y ) # should match previous result from quantile_response

## Get Q1 response
quantile_response( df, scoring_function_parameters = list( percentile = 0.25 ) )
quantile( df$y, 0.25 ) # should match previous result from quantile_response

## Get max response
quantile_response( df, scoring_function_parameters = list( percentile = 1 ) )
max( df$y ) # should match previous result from quantile_response
}
\seealso{
\link{TSDT}, \link{diff_quantile_response}, \link{quantile}
}
