% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETSP.R
\name{ETSP}
\alias{ETSP}
\alias{as.ETSP}
\alias{as.ETSP.matrix}
\alias{as.ETSP.data.frame}
\alias{as.TSP.ETSP}
\alias{as.matrix.ETSP}
\alias{print.ETSP}
\alias{n_of_cities.ETSP}
\alias{labels.ETSP}
\alias{image.ETSP}
\alias{plot.ETSP}
\title{Class ETSP -- Euclidean traveling salesperson problem}
\usage{
ETSP(x, labels = NULL)

as.ETSP(x)

\method{as.ETSP}{matrix}(x)

\method{as.ETSP}{data.frame}(x)

\method{as.TSP}{ETSP}(x)

\method{as.matrix}{ETSP}(x, ...)

\method{print}{ETSP}(x, ...)

\method{n_of_cities}{ETSP}(x)

\method{labels}{ETSP}(object, ...)

\method{image}{ETSP}(x, order, col = gray.colors(64), ...)

\method{plot}{ETSP}(x, y = NULL, tour = NULL, tour_lty = 2, tour_col = 2, labels = TRUE, ...)
}
\arguments{
\item{x, object}{an object (data.frame or matrix) to be converted into a
\code{ETSP} or, for the methods, an object of class \code{ETSP}.}

\item{labels}{logical; plot city labels.}

\item{...}{further arguments are passed on.}

\item{order}{order of cities for the image as an integer vector or an object
of class \link{TOUR}.}

\item{col}{color scheme for image.}

\item{tour, y}{a tour to be visualized.}

\item{tour_lty, tour_col}{line type and color for tour.}
}
\value{
\itemize{
\item \code{ETSP()} returns \code{x} as an object of class \code{ETSP}.
\item \code{n_of_cities()} returns the number of cities in \code{x}.
\item \code{labels()} returns a vector with the names of the cities in \code{x}.
}
}
\description{
Constructor to create an instance of a Euclidean traveling salesperson
problem (TSP) represented by city coordinates and some auxiliary methods.
}
\details{
Objects of class \code{ETSP} are internally represented as a \code{matrix}
objects (use \code{as.matrix()} to get the \code{matrix} object).
}
\examples{
## create a random ETSP
n <- 20
x <- data.frame(x = runif(n), y = runif(n), row.names = LETTERS[1:n])
etsp <- ETSP(x)
etsp

## use some methods
n_of_cities(etsp)
labels(etsp)

## plot ETSP and solution
tour <- solve_TSP(etsp)
tour

plot(etsp, tour, tour_col = "red")

# plot with custom labels
plot(etsp, tour, tour_col = "red", labels = FALSE)
text(etsp, paste("City", rownames(etsp)), pos = 1)
}
\seealso{
Other TSP: 
\code{\link{ATSP}()},
\code{\link{Concorde}},
\code{\link{TSP}()},
\code{\link{TSPLIB}},
\code{\link{insert_dummy}()},
\code{\link{reformulate_ATSP_as_TSP}()},
\code{\link{solve_TSP}()}
}
\author{
Michael Hahsler
}
\concept{TSP}
\keyword{classes}
