% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{repr_paa}
\alias{repr_paa}
\title{PAA - Piecewise Aggregate Approximation}
\usage{
repr_paa(x, q, func)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{q}{the integer of the length of the "piece"}

\item{func}{the aggregation function. Can be meanC, medianC, sumC, minC or maxC or similar aggregation function}
}
\value{
the numeric vector
}
\description{
The \code{repr_paa} computes PAA representation from a vector.
}
\details{
PAA with possibility to use arbitrary aggregation function.
The original method uses average as aggregation function.
}
\examples{
repr_paa(rnorm(11), 2, meanC)

}
\references{
Keogh E, Chakrabarti K, Pazzani M, Mehrotra Sh (2001)
Dimensionality Reduction for Fast Similarity Search in Large Time Series Databases.
Knowledge and Information Systems 3(3):263-286
}
\seealso{
\code{\link[TSrepr]{repr_dwt}, \link[TSrepr]{repr_dft}, \link[TSrepr]{repr_dct}, \link[TSrepr]{repr_sma}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
