% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_tools.R
\name{arima_diag}
\alias{arima_diag}
\title{Diagnostic Plots for ARIMA Models}
\usage{
arima_diag(ts.obj, method = list(first = list(diff = 1, log = TRUE, title
  = "First Difference with Log Transformation")), cor = TRUE)
}
\arguments{
\item{ts.obj}{A ts object}

\item{method}{A list, defines the transformation parameters of each plot. 
Each plot should be defined by a list, where the name of the list defines the plot ID. 
The plot parameters are:

diff - an integer, defines the degree of diffrence
log - a boolean, optional, defines if log transformation should be used
title - optional, the plot title}

\item{cor}{A boolean, if TRUE (default), will plot the series ACF and PACF}
}
\value{
A plot
}
\description{
Diagnostic Plots for ARIMA Models
}
\details{
The arima_diag function provides a set of diagnostic plots for identify the ARIMA model parameters.
The ACF and PACF can assist in identifying the AR and MA process, 
and the diffrence plotting hel in idenitfying the degree of differencing that required to make the series stationary
}
\examples{

data(USgas)

arima_diag(ts.obj = USgas)

# Can define more than one differencing plot using the 'method' argument

arima_diag(ts.obj = USgas,
           cor = TRUE,
           method = list(first = list(diff = 1, 
                                      log = TRUE,
                                      title = "First Diff with Log Transformation"),
                         Second = list(diff = c(1,1),
                                       log = TRUE,
                                       title = "Second Diff with Log Transformation")))
}
