% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tww.R
\name{tww}
\alias{tww}
\title{TWW Growth Model}
\usage{
tww(x, y, start = list(alpha,theta,beta,delta = NULL,phi = NULL), ...)
}
\arguments{
\item{x}{A numeric vector that must be same length as \code{y}}

\item{y}{A numeric vector that must be same length as \code{x}}

\item{start}{A numeric list.
The supplied list of numbers are designated as starting parameters, or initial conditions,
inserted into the \pkg{nls} function as \eqn{\alpha}, \eqn{\theta}, \eqn{\beta}, \eqn{\delta},
and \eqn{\phi}, respectively. The length of the list determines which model will be used.
List length should be between 3 and 5. See Details for more information.}

\item{...}{Additional optional arguments passed to the \pkg{nls} function.}
}
\value{
This function is designed to calculate the parameter estimates, standard errors, and p-values
        for the TWW Growth (Decay) Model as well as estimating \eqn{C_{TWW}}, inflection point (poi) coordinates,
        sum of squares error (SSE), Akaike information criterion (AIC), and Bayesian information criterion (BIC).
}
\description{
Calculates the 3-, 4-, and 5-parameter TWW Growth model estimates. For those who
    use the cycle number and fluorescence intensity to analyze real-time, or quantitative polymerase
    chain reaction (qPCR), this function will calculate the TWW cycle threshold (\eqn{C_{TWW}}).
}
\details{
The initialized parameters are inserted as a list in \code{start} and are passed to the \pkg{nls} function using the Gauss-Newton algorithm.
If you intend to use a 3-parameter model, insert values for \eqn{\alpha}, \eqn{\theta}, and \eqn{\beta} only. If you plan to use the
4-parameter model, you must insert values for \eqn{\delta} in addition to \eqn{\alpha}, \eqn{\theta}, and \eqn{\beta}.
If you intend to use the 5-parameter model, you need to insert initial values for all five parameters. The parameters always follows the
order \eqn{\alpha}, \eqn{\theta}, \eqn{\beta}, \eqn{\delta}, and \eqn{\phi}. The number of items in the list
determines your choice of model.
The 3-parameter growth model has the form
  \deqn{F(x)=\alpha\ e^{-ArcSinh\left(\theta e^{-\beta x}\right)}}
while the 4-parameter growth model follows the equation
  \deqn{F(x)=\alpha\ e^{-ArcSinh\left(\theta e^{-\beta x}\right)}+\delta}
and the 5-parameter growth model is given by
  \deqn{F(x)=\alpha\ e^{-\phi ArcSinh\left(\theta e^{-\beta x}\right)}+\delta}
In each of these models, \eqn{\theta} > 0. In the 5-parameter model, \eqn{\phi} > 0.
\eqn{C_{TWW}} is only applicable to qPCR data and should not be considered in other cases.
}
\examples{
#Data source: Guescini, M et al. BMC Bioinformatics (2008) Vol 9 Pg 326
fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,
                  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                 0.479738750,  0.938835708,  1.821600610,  3.451747880,
                 6.381471101, 11.318606976, 18.669664284, 27.684433343,
                 36.269197588, 42.479513622, 46.054327283, 47.977882896,
                 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                 50.731472869, 50.833299572, 50.869115345, 50.895051731,
                 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                 50.899942221, 50.876866864, 50.878926417, 50.876938783,
                 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                 50.844847982, 50.851447716, 50.841698121, 50.840564351,
                 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                 50.823743224, 50.857581865)

cycle_number <- 1:50

#3-parameter model
tww(x = cycle_number, y = fluorescence, start = list(40,15.5,0.05))

#4-parameter model
tww(x = cycle_number, y = fluorescence, start = list(40,15.5,0.05,0),
    algorithm = "port")$c_tww

#5-parameter model
summary(tww(x = cycle_number, y = fluorescence, start = list(40,15.5,0.05,0,1),
            algorithm = "port",
            control = nls.control(maxiter = 250)))

}
\seealso{
\code{\link{nls}} to determine the nonlinear (weighted) least-squares estimates of the parameters of a nonlinear model.
}
