% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{formatting}
\alias{formatting}
\alias{numericEdgeWeight}
\alias{prettyEdgeWeight}
\title{Format Edgeweights (times and distances)}
\usage{
numericEdgeWeight(edgeWeight, type)

prettyEdgeWeight(edgeWeight, type)
}
\arguments{
\item{edgeWeight}{A time or distance, in numeric or string form.}

\item{type}{Either 'time' or 'distance'.}
}
\value{
Either a numeric or formatted edgeweight
}
\description{
Functions to make the interface easier and more intuitive to use - they convert
numeric edgeweights (e.g. 900) to character strings (e.g. "15min"), and vice versa.
}
\examples{
numericEdgeWeight("1hr 30m", "time") # 5400
numericEdgeWeight("1ml", "distance") # 1609

prettyEdgeWeight(1245, "time") # 30min 45s
prettyEdgeWeight(1245, "distance") # 1km 245m

}
