% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_tpose.R
\name{t_tpose}
\alias{t_tpose}
\title{Tensor transpose}
\usage{
t_tpose(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode tensor}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transorm

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
S3 class tensor
}
\description{
Performs the transpose of a symmetric 3-mode tensor using any discrete transform.
}
\examples{
T <- t_rand(modes=c(2,3,4))
print(t_tpose(T,"dct"))
}
\references{
Brachat, J., Comon, P., Mourrain, B., & Tsigaridas, E. (2010). Symmetric tensor decomposition. Linear Algebra and its Applications, 433(11-12), 1851-1872.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
