% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cbPalettes}
\alias{cbPalettes}
\alias{cbPalette8}
\alias{cbPalette13}
\alias{cbPalette15}
\title{Palettes compatible with colour blindness}
\format{Character vectors of lengths 8, 13 and 15.}
\source{
\itemize{
\item \code{cbPalette8}: \cite{Wong B. 2011. Color blindness. Nat. Methods. 8:441. \doi{10.1038/nmeth.1618}}
\item \code{cbPalette15}: \url{http://mkweb.bcgsc.ca/biovis2012/color-blindness-palette.png}
}
}
\usage{
cbPalette8

cbPalette13

cbPalette15
}
\description{
Colour palettes recommended for use with colour blind audiences.
}
\details{
\code{cbPalette15} is a \href{http://mkweb.bcgsc.ca/brewer/}{Brewer palette}.
Because colours 4 and 7 are difficult to distinguish from colours 13 and 3,
respectively, in individuals with tritanopia, \code{cbPalette13} omits these
colours (i.e. \code{cbPalette13 <- cbPalette15[-c(4, 7)]}).
}
\examples{
data('cbPalette8')
plot.new()
plot.window(xlim = c(1, 16), ylim = c(0, 3))
text(1:8 * 2, 3, 1:8, col = cbPalette8)
points(1:8 * 2, rep(2, 8), col = cbPalette8, pch = 15)

data('cbPalette15')
text(1:15, 1, col = cbPalette15)
text(c(4, 7), 1, '[   ]')
points(1:15, rep(0, 15), col = cbPalette15, pch = 15)

}
\keyword{datasets}
