% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotate.R
\name{Annotate}
\alias{Annotate}
\title{Annotate points on a ternary plot}
\usage{
Annotate(
  coordinates,
  labels,
  side,
  outset = 0.16,
  line.col = col,
  lty = par("lty"),
  lwd = par("lwd"),
  col = par("col"),
  font = par("font"),
  offset = 0.5,
  ...
)
}
\arguments{
\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}

\item{labels}{Character vector specifying text with which to annotate
each entry in \code{coordinates}.}

\item{side}{Optional vector specifying which side of the ternary
plot each point should be labelled on, using the notation \verb{"a", "b", "c"} or
\verb{1, 2, 3}.
Entries of \code{"n"} or \code{0} will not be annotated
(but still require an entry in \code{labels}).
Entries of \code{NA} will be allocated a side automatically,
based on the midpoint of \code{coordinates}.}

\item{outset}{Numeric specifying distance from plot margins to labels.}

\item{line.col, lty, lwd}{parameters to \code{\link[=segments]{segments()}}.}

\item{col, font, offset}{parameters to \code{\link[=text]{text()}}.}

\item{\dots}{Further parameters to \code{\link[=text]{text()}} and \code{\link[=segments]{segments()}}.}
}
\description{
\code{Annotate()} identifies and label individual points on a ternary diagram
in the plot margins.
}
\examples{
# Load some data
data("Seatbelts")
seats <- c("drivers", "front", "rear")
seat <- Seatbelts[month.abb \%in\% "Oct", seats]
law <- Seatbelts[month.abb \%in\% "Oct", "law"]

# Set up plot
oPar <- par(mar = c(2, 0, 0, 0))
TernaryPlot(alab = seats[1], blab = seats[2], clab = seats[3])
TernaryPoints(seat, cex = 0.8, col = 2 + law)

# Annotate points by year
Annotate(seat, labels = 1969:1984, col = 2 + law)

# Restore original graphical parameters
par(oPar)  
}
\seealso{
\href{https://ms609.github.io/Ternary/dev/articles/annotation.html}{Annotation vignette} gives
further suggestions for manual annotation.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
