% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TernaryTiles}
\alias{TernaryTiles}
\alias{TernaryUpTiles}
\alias{TernaryDownTiles}
\alias{TernaryLeftTiles}
\alias{TernaryRightTiles}
\title{Paint tiles on ternary plot}
\usage{
TernaryTiles(
  x,
  y,
  down,
  resolution,
  col,
  direction = getOption("ternDirection", 1L)
)
}
\arguments{
\item{x, y}{Numeric vectors specifying \emph{x} and \emph{y} coordinates of centres of each triangle.}

\item{down}{Logical vector specifying \code{TRUE} if each triangle should point
down (or right), \code{FALSE} otherwise.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{col}{Vector specifying the colour with which to fill each triangle.}

\item{direction}{(optional) Integer specifying the direction that the
current ternary plot should point: 1, up; 2, right; 3, down; 4, left.}
}
\value{
\code{TernaryTiles()} is called for its side effect – painting a ternary
plot with coloured tiles.  It invisibly returns \code{NULL}.
}
\description{
Function to fill a ternary plot with coloured tiles.  Useful in combination with
\code{\link[=TernaryPointValues]{TernaryPointValues()}} and \code{\link[=TernaryContour]{TernaryContour()}}.
}
\examples{
TernaryPlot()
TernaryXRange()
TernaryYRange()

TernaryTiles(0, 0.5, TRUE, 10, "red")
xy <- TernaryCoords(c(4, 3, 3))
TernaryTiles(xy[1], xy[2], FALSE, 5, "darkblue")
}
\seealso{
Other functions for colouring and shading: 
\code{\link{ColourTernary}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{functions for colouring and shading}
