% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/power.taNegbin.test.R
\name{power.taNegbin.test}
\alias{power.taNegbin.test}
\title{Power related calcuations for three-armed clinical trials with negative binomial distributed endpoints}
\usage{
power.taNegbin.test(rateExp, rateRef, ratePla, shape, Delta, sig.level = NULL,
  power = NULL, n = NULL, type = c("restricted", "unrestricted"),
  allocation = c(1/3, 1/3, 1/3))
}
\arguments{
\item{rateExp}{A numeric value specifying the rate of the experimental treatment group in the alternative hypothesis}

\item{rateRef}{A numeric value specifying the rate of the reference treatment group in the alternative hypothesis}

\item{ratePla}{A numeric value specifying the rate of the placebo treatment group in the alternative hypothesis}

\item{shape}{A numeric value specifying the shape parameter}

\item{Delta}{A numeric value specifying the non-inferiority or superiority margin. Is between 0 and 1 in case of non-inferiority and larger than 1 in case of superiority.}

\item{sig.level}{A numeric value specifying the significance level (type I error probability)}

\item{power}{A numeric value specifying the target power (1 - type II error probability)}

\item{n}{The total sample size. Needs to be at least 7.}

\item{type}{A character string determing how the variance for the Wald-type test statistic is estimated, must be \emph{restricted}, or \emph{unrestricted}}

\item{allocation}{A (non-empty) vector specifying the sample size allocation (nExp/n, nRef/n, nPla/n)}
}
\value{
A list with class "power.htest" containing the following components:
\item{n}{The total sample size}
\item{power}{A numeric value specifying the target power}
\item{Delta}{A numeric value specifying the non-inferiority or superiority margin. }
\item{sig.level}{A character string specifying the significance level}
\item{type}{A character string indicating what type of Wald-type test will be performed}
\item{allocation}{A vector with the sample size allocation (nExp/n, nRef/n, nPla/n)}
\item{sig.level}{The significance level (Type I error probability)}
\item{nExp}{A numeric value specifying the number of sample in the experimental treatment group}
\item{nRef}{A numeric value specifying the number of sample in the reference treatment group}
\item{nPla}{A numeric value specifying the number of sample in the placebo treatment group}
}
\description{
Compute power, sample size, or level of significance for Wald-type test for non-inferiority or superiority of the experimental treatment versus reference treatment with respect to placebo.
}
\details{
If the individual group sample sizes, i.e. \code{n*allocation} are not natural number, the parameters \emph{n} and \emph{allocation} will be re-calculated.
}
\examples{
# Example for type = 'unrestricted': Calculation of n, power, and sig.level.
# Expect n=1038, power=0.8, sig.level=0.025, respectively
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 sig.level = 0.025, power = 0.8, type = 'unrestricted', allocation = c(1/3, 1/3, 1/3))$n
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 sig.level = 0.025, n = 1038, type = 'unrestricted', allocation = c(1/3, 1/3, 1/3))$power
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 power = 0.8007362, n = 1038, type = 'unrestricted', allocation = c(1/3, 1/3, 1/3))$sig.level

# Example for type = 'restricted' calculation of n, power, and sig.level.
# Expect n=1092, power=0.8, sig.level=0.025
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 sig.level = 0.025, power = 0.8, type = 'restricted', allocation = c(1/3, 1/3, 1/3))$n
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 sig.level = 0.025, n = 1092, type = 'restricted', allocation = c(1/3, 1/3, 1/3))$power
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 n = 1092, power = 0.8008113, type = 'restricted', allocation = c(1/3, 1/3, 1/3))$sig.level

# Example for recalculation of 'allocation' and 'n'
power.taNegbin.test(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 n = 1001, power = 0.8, allocation = c(0.25, 0.5, 0.25))
}
\keyword{NegativeBinomial}
\keyword{power}

