\name{MarketSell}
\alias{MarketSell}
\title{Execute Market Sell Order}
\description{
(Try) to sell a given instrument at given date and time, by market order. The 
function can at most penetrate 5 levels of bid prices. For large capital, the
average executed price WILL be depressed. There is a possibility that the order 
will not be fully executed and some holding volumes will remain.
}
\usage{
MarketSell(dir = dir, date, orderTime, dfLog, costOut = 0.001) 
}
\arguments{
  \item{dir}{The directory containing the Tick data.}
  \item{date}{the date for placing the order.}
  \item{orderTime}{Time of the day to place the market order.}
  \item{dfLog}{The dataframe generated by buy-orders.}
  \item{costOut}{transaction cost for selling.}
}
\value{
The same dataframe dfLog, with corresponding entries updated.
}
\examples{
## locate tick data directory ##
dir <- system.file("extdata", '', package = "TickExec")

## establish a posiyion to sell ##
dfLog = LimitBuy(dir = dir, date = 20141013, ticker = 000001, capital = 1e6, 
                 limitPrice = NA, orderFrom = 94545, orderLast = 600, 
                 costIn = 0.001)

## sell ##
dfLogSold = MarketSell(dir = dir, date = 20141014, orderTime = 140001, 
                       dfLog = dfLog, costOut = 0.001)
                       
## see result ##
dfLogSold
}
\keyword{market buy order}