% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical-tidy-bootstrap.R
\name{tidy_bootstrap}
\alias{tidy_bootstrap}
\title{Bootstrap Empirical Data}
\usage{
tidy_bootstrap(
  .x,
  .num_sims = 2000,
  .proportion = 0.8,
  .distribution_type = "continuous"
)
}
\arguments{
\item{.x}{The vector of data being passed to the function. Must be a numeric
vector.}

\item{.num_sims}{The default is 2000, can be set to anything desired. A warning
will pass to the console if the value is less than 2000.}

\item{.proportion}{How much of the original data do you want to pass through
to the sampling function. The default is 0.80 (80\%)}

\item{.distribution_type}{This can either be 'continuous' or 'discrete'}
}
\value{
A nested tibble
}
\description{
Takes an input vector of numeric data and produces a bootstrapped
nested tibble by simulation number.
}
\details{
This function will take in a numeric input vector and produce a tibble
of bootstrapped values in a list. The table that is output will have two columns:
\code{sim_number} and \code{bootstrap_samples}

The \code{sim_number} corresponds to how many times you want the data to be resampled,
and the \code{bootstrap_samples} column contains a list of the boostrapped resampled
data.
}
\examples{
x <- mtcars$mpg
tidy_bootstrap(x)

}
\seealso{
Other Bootstrap: 
\code{\link{bootstrap_unnest_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Bootstrap}
