% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-skewness.R
\name{tidy_skewness_vec}
\alias{tidy_skewness_vec}
\title{Compute Skewness of a Vector}
\usage{
tidy_skewness_vec(.x)
}
\arguments{
\item{.x}{A numeric vector of length four or more.}
}
\value{
The skewness of a vector
}
\description{
This function takes in a vector as it's input and will return the skewness
of that vector. The length of this vector must be at least four numbers. The
skewness explains the 'tailedness' of the distribution of data.

\verb{((1/n) * sum(x - mu\})^3) / ((()1/n) * sum(x - mu)^2)^(3/2)}
}
\details{
A function to return the skewness of a vector.
}
\examples{
tidy_skewness_vec(rnorm(100, 3, 2))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Skewness}

Other Statistic: 
\code{\link{ci_hi}()},
\code{\link{ci_lo}()},
\code{\link{tidy_kurtosis_vec}()},
\code{\link{tidy_range_statistic}()},
\code{\link{tidy_stat_tbl}()}

Other Vector Function: 
\code{\link{bootstrap_p_vec}()},
\code{\link{bootstrap_q_vec}()},
\code{\link{cgmean}()},
\code{\link{chmean}()},
\code{\link{ckurtosis}()},
\code{\link{cmean}()},
\code{\link{cmedian}()},
\code{\link{csd}()},
\code{\link{cskewness}()},
\code{\link{cvar}()},
\code{\link{tidy_kurtosis_vec}()},
\code{\link{tidy_scale_zero_one_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Statistic}
\concept{Vector Function}
